precision mediump float;

#define HIGHLIGHT_BOTTOM_COLOUR       vec3(0.3,0.9,0.9)
#define HIGHLIGHT_TOP_COLOUR          vec3(0.2,0.2,0.2)
#define HIGHLIGHT_COLOR_MIX           0.01

uniform sampler2D texture_diffuse;
uniform sampler2D texture_normal;

varying vec2 v_uv;

void main()
{
    // Fetch Fragments Normal + Diffuse textures
    vec4 diffuse = texture2D( texture_diffuse, v_uv);
    vec4 normal  = texture2D( texture_normal, v_uv);
    
    vec4 ssnormal   = (normal*2.0)-1.0;
    float nl_bottom = dot(ssnormal.xyz,vec3(0.0,1.0,0.0));
    float nl_top    = dot(ssnormal.xyz,vec3(0.0,-1.0,0.0));
    vec3 attr = (HIGHLIGHT_BOTTOM_COLOUR * clamp(nl_bottom,0.0,1.0)) + (HIGHLIGHT_TOP_COLOUR * clamp(nl_top,0.0,1.0));
    diffuse.xyz = mix(diffuse.xyz,attr,HIGHLIGHT_COLOR_MIX);
            
    gl_FragColor = diffuse;    
}
